# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Visualise as tree.

# Approach
<!-- Describe your approach to solving the problem. -->
My approach is like : the chain should be visualised as a tree : strings from which lesser strings are derived on lower part and strings from which large network can be formed on upper areas

---
Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

# Complexity
- Time complexity : $$O(n^3)$$
- - This time complexity was used to update the heights 
- - otherwise other functions had lesser complexity
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(n)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class TreeNode {
    int data;
    int height;
    ArrayList<TreeNode> children;

    public TreeNode(int data) {
        this.data = data;
        this.height = 1;
        this.children = new ArrayList<TreeNode>();
    }

    public void addChild(TreeNode node) {
        this.height = Math.max(height, node.height+1) ;
        this.children.add(node);
    }
}

public class Solution{   

    public static int longestStrChain(String[] words) {
         HashMap<Integer, ArrayList<Integer>> h = new HashMap<>();
        for( int i = 0; i < words.length; i++){
            h.put(i, new ArrayList<>());
        }
        for( int i = 0; i < words.length; i++){      // storing indices which are subsequences of current index
            for( int j = 0; j < words.length; j++){
                if( checkPred(words[j], words[i])){
                    h.get(i).add(j);
                }
            }
        }
        /*for( int k : h.keySet()){
            System.out.println(k + " " + h.get(k));
        }*/
        // as they will be subsequence of itself , so removing themself from their own list
        /*for( int k : h.keySet()){
            h.get(k).remove(k);
        }*/
        TreeNode[] t = new TreeNode[words.length];   // array to store the childs of respective trees
        for( int i = 0; i < words.length; i++){      // making each index as treenode
            t[i] = new TreeNode(i);
        }
        for( int i = 0; i < words.length; i++){     // constructing tree
            for( int j : h.get(i)){
                t[i].addChild(t[j]);
                //System.out.println( "child added to " + i + " child is " + j);
                //System.out.println("height of " + i +" is " + t[i].height);
            }
        }
        /*for( int i = 0; i < words.length; i++){     // printing height
            System.out.println( i + " h : " + t[i].height);
        }*/

        //My final solution to update height
        for(int c = 0; c < t.length; c++){
            for( int i= 0; i < t.length; i++){
                for( int j = 0; j < t[i].children.size(); j++){
                   t[i].height = Math.max(t[i].height, t[i].children.get(j).height+1);
                }
            }
        }
        
        /*System.out.println("Updated Height");
        for( int i = 0; i < words.length; i++){
            System.out.println( i + " h : " + t[i].height);
        }*/

        int maxlevel = 0;
        for( int i = 0; i < words.length; i++){
            maxlevel = Math.max( maxlevel, t[i].height);
        }
    
        return maxlevel;
    }

    static boolean checkPred( String s, String w){  // checking if 's' is subsequenece of 'w' or not
    
        if( w.length() - s.length() != 1){
            return false;
        }
        Stack<Character> st = new Stack<>();
        for( int i = s.length() - 1; i >= 0; i--){
            st.push(s.charAt(i));
        }   
        int skip = 0; 
        for( int i = 0; i < w.length(); i++){
            if( skip > 1){   // as it is given that only one letter is missing
                return false;
            }
            if( st.isEmpty()){
                break;
            }
            if( w.charAt(i) == st.peek()){
                st.pop();
            }
            else if( w.charAt(i) != st.peek()){
                skip++;
            }
            
        }
        if( st.isEmpty() ){
                return true;
            }
        return false;

    }
}
```